unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMObj, MMAVI, MMSlider, StdCtrls, MMCstDlg, MMAVICtl;

type
  TForm1 = class(TForm)
    AVIDisplay: TMMAVIVideoDisplay;
    OpenDialog: TMMAVIOpenDialog;
    Button1: TButton;
    Slider: TMMSlider;
    AVIFile: TMMAVIFile;
    procedure Button1Click(Sender: TObject);
    procedure SliderChange(Sender: TObject);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.Button1Click(Sender: TObject);
begin
   if OpenDialog.Execute then
   begin
      AVIFile.FileName := OpenDialog.FileName;
      Caption := ExtractFileName(OpenDialog.FileName);

      { open the file }
      AVIFile.OpenFile;
      AVIDisplay.FreeStreams;

      { add a reference to the display }
      AVIDisplay.AddFile(AVIFile);
      AVIDisplay.Refresh;

      { select the first stream, we assume this is a video stream }
      AVIDisplay.StreamIdx := 0;

      { set the max value for the slider }
      Slider.MaxValue:= AVIFile.Streams[0].Length-1;
      Slider.Enabled := True;
   end;
end;

procedure TForm1.SliderChange(Sender: TObject);
begin
   AVIDisplay.FrameIdx := Slider.Position;
end;

end.
